#ifdef UNICODE
error(NOT DESIGNED FOR UNICODE)
#endif

#ifndef WIN32
error(DESIGNED FOR WIN32 ONLY)
#endif

#ifdef __cplusplus
extern "C"
{
#endif

struct str_ima_handle { int unused; };
typedef struct str_ima_handle FAR * HIMA;

#define WIMAAPI WINAPI

#ifndef CALLBACK_FILEIO_DEFINED
#define CALLBACK_FILEIO_DEFINED

typedef BOOL (WINAPI* FILEIOCALLBACK) (LPCVOID lpData,
                                       DWORD dwDataSize,
                                       LPVOID lpUsrParam);
#endif

#ifndef TYPEDISKH
typedef enum
{
  NOTHING=0,
  USED,
  ALL,
  BEGINFLOPPY,
  ONLYBOOT
} CHOICEAPP;
#endif


#ifndef _INC_DISK

#ifndef MAXLFN
#define MAXLFN 256
#endif

typedef struct
{
  char nom[8];
  char ext[3];
  char szCompactName[13];
  BYTE bAttr;

  BYTE dir_CreateMSec;
  WORD dir_CreateDate;
  WORD DosTime;
  WORD DosDate;

  BOOL fIsSubDir;
  BOOL fSel; // for private use of client app.
  BOOL fLfnEntry;
  DWORD dwSize;
  UINT uiPosInDir;
  DWORD dwLocalisation;
  DWORD dwTrueSize;
  char longname[MAXLFN];
  WORD dir_CreateTime;
  WORD dir_LastAccessDate;
} DIRINFO;
typedef DIRINFO* LPDIRINFO; // for info, huge in win16 WinImage


#ifndef EVENTNOTIF_DEFINED
#define EVENTNOTIF_DEFINED
typedef DWORD (WINAPI* EVENTNOTIFCALLBACK) (DWORD dwEvent,
                                            DWORD dwEventParam,DWORD dwWin32Err,
                                            LPVOID lpParam,LPVOID lpUsrParam);

// dwEvent contain a DWEV_xxx value, see below
// lpUsrParam contain user param gived to function

#define DWEV_ERRORSUPINFO       ((DWORD)0x7fff0001)
// IO Error with supplemental info (in ReadFloppy and WriteFloppy)
// dwEventParam = WinImage error number (see below), Bios like error number
// dwWin32Err : Win32 error number, like GetLastError()
// lpParam * pointer to an ERROR_SUPINFO structure
// return value : IDRETRY (4), IDABORT (3), IDIGNORE (5) or  IDCANCEL (2)
//   dwEventParam = 0x01         "Internal error 1\n"
//   dwEventParam = 0x02         "Address mark not found"
//   dwEventParam = 0x03         "Diskette is write-protected"
//   dwEventParam = 0x04         "Sector not found"
//   dwEventParam = 0x08         "DMA overflow"
//   dwEventParam = 0x09         "Internal error 9"
//   dwEventParam = 0x10         "Error in reading"
//   dwEventParam = 0x20         "Error in floppy adapter"
//   dwEventParam = 0x40         "Track not found"
//   dwEventParam = 0x80         "There is no floppy in the drive"
//   dwEventParam = 0x100        "Floppies do not match"


#define DWEV_ERRORWIN32         ((DWORD)0x7fff0002)
// Win32 IO Error in ReadFloppy and WriteFloppy and ReadLargeIma and WriteLargeIma
// dwEventParam = WinImage error number (see DWEV_ERRORSUPINFO), Bios like error number or 0
// dwWin32Err : Win32 error number, like GetLastError()
// return value : IDRETRY to retry (when possible)
// elsewhere (IDCANCEL or 0) to stop


#define DWEV_ERRORCANTACCESS    ((DWORD)0x7fff0003)
// in ReadFloppy* and WriteFloppy*
// "Drive cannot be accessed - Check to see if another application is using it"
// return value not used

#define DWEV_ERRORDRIVEEMPTY    ((DWORD)0x7fff0004)
// in ReadFloppy* and WriteFloppy*
// "There is no floppy in the drive"
// return value not used

#define DWEV_ERROR_NOT_MATCH    ((DWORD)0x7fff0005)
// in ReadFloppy*
// "Floppies do not match"
// return value not used

#define DWEV_UNSTDFMT           ((DWORD)0x7fff0006)
// in ReadFloppy* and WriteFloppy*
// "The current image format differs from the standard format for this disk drive"
// return value : IDCANCEL to abort, IDOK (1) or any other value to continue,

#define DWEV_UNSUPFMT           ((DWORD)0x7fff0007)
// in WriteFloppy* and WriteLargeIma
// "The current image format is not supported by the disk drive"
// return value not used

#define DWEV_DIFFTYPEDISK       ((DWORD)0x7fff0008)
// in WriteFloppy*
// "Disk and image formats do not match\nDo you want to reformat it?"
// return IDYES (6) or IDNO (7). IDNO stop, any other value continue

#define DWEV_DISKHASDATA        ((DWORD)0x7fff0009)
// in WriteFloppy*
// "Disk is not empty, all data on your disk will be lost!\nDo you want to continue?"
// return IDYES (6) or IDNO (7). IDNO stop, any other value continue

#define DWEV_PROGRESSPERCENT    ((DWORD)0x7fff000a)
// Give % progress info
// dwEventParam between 0 and 100
// for ExtractFile and InjectFile, lpParam contain a PROGRESSFILE_SUPINFO structure
// return value : IDCANCEL (2) to stop, 0 (or any other value) to continue


#define DWEV_ERRORASPI          ((DWORD)0x7fff000b)
// Aspi error in WimLargeReadAspiCDImage*
// dwEventParam contain first sector number of range error
// return value : IDABORT, IDRETRY or IDIGNORE

#define DWEV_ERRORWRITEIMAGEFILE    ((DWORD)0x7fff000c)
// error in writing image file in WimLargeReadAspiCDImage*
// dwWin32Err : Win32 error number, like GetLastError()


#define DWEV_ERRORIOCTL             ((DWORD)0x7fff000d)
// IOCTL error when reading Disk partition under Win9x
// dwEventParam is Int25/26 error value
// return value : IDCANCEL or IDRETRY

#define DWEV_ROOTREADDONE           ((DWORD)0x7fff000e)
// when reading FAT image, say when the root is read
// return value is not used

#ifndef LOCATEERROR_DEFINED
#define LOCATEERROR_DEFINED
typedef enum
{
  ON_FORMAT=0,
  ON_READ,
  ON_WRITE,
  ON_COMPARE
} LOCATEERROR;
#endif

#ifndef SUPINFOSTRUCT_DEFINED
#define SUPINFOSTRUCT_DEFINED
typedef struct
{
    DWORD dwSizeStruct;
    LOCATEERROR LocErr;
    DWORD dwHead;
    DWORD dwTrack;

    DWORD dwPosLow;
    DWORD dwPosHigh;
    DWORD dwStyleAnswer;

    DWORD dwErrNumber;
    LPCTSTR lpszErrorText;
} ERROR_SUPINFO;

// for ExtractFile and InjectFile, in event DWEV_PROGRESSPERCENT lpParam contain a
//    PROGRESSFILE_SUPINFO structure
typedef struct
{
    DWORD dwSizeStruct;
    DWORD dwCurrentPos;
    DWORD dwReserved1;
    DWORD dwTotalSize;
    DWORD dwReserved2;
    LPCTSTR lpszName;
    LPCTSTR lpszFullName;
} PROGRESSFILE_SUPINFO;
#endif

#endif

#endif


#ifndef SORT_NONE
#define SORT_NONE 72
#define SORT_NAME 73
#define SORT_EXT  74
#define SORT_SIZE 75
#define SORT_DATE 76
#endif

#ifndef CDM_ROOT
#define CDM_ROOT  50
#define CDM_UPPER 51
#define CDM_ENTRY 52 // use ChszDir
#endif


typedef enum
{
  NO_FLOPPY=0,
  FLOPPY_360,
  FLOPPY_12M,
  FLOPPY_720,
  FLOPPY_144,
  FLOPPY_288,
  LDISK_REMOVABLE,
  LDISK_HARDDISK,
  LDISK_CDROM,
  FLOPPY_LS120
} DRIVEINFO;

// HWND_NO_PROGRESS : hWnd parameter to ReadImaFile or WriteImaFile to have no
//  WinImage progress bar window
#define HWND_NO_PROGRESS ((HWND)INVALID_HANDLE_VALUE)

// CreateMemFatHima : Create an Image Object.
// you need call ReadImaFile, ReadFloppy or MakeEmptyImage
HIMA WIMAAPI CreateMemFatHima();

// CreateMemHfsHima : Create an Image Object for Mac floppy.
// you need call ReadImaFile, ReadFloppy
// extract, inject... cannot be used
HIMA WIMAAPI CreateMemHfsHima();

// CreateCDIsoIma : Create an Image Object by loading CDRom ISO image
//  lpFn : Filename of .ISO file
//  inject,...cannot be used
HIMA WIMAAPI CreateCDIsoIma(LPCSTR lpFn);

// OpenFatLargeFile : Open a large disk image (hard disk image)
//  hWnd : parent window for progress window
//  lpFn : FileName
//  dwPosFileBegin : position in file (usualy 0)
//  dwPosFileBegin : position in file, high (usualy 0), for file > 4GB
//  fReadOnlyAsked : if the file must be opened in read-only mode
HIMA WIMAAPI OpenFatLargeFile(HWND hWnd,LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);
HIMA WIMAAPI OpenFatLargeFileCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);

HIMA WIMAAPI OpenLargeImageFile(HWND hWnd,LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);

HIMA WIMAAPI OpenLargeImageFileCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);

// DeleteIma : Delete an Image Object.
void WIMAAPI DeleteIma(HIMA);

// Read an image file (.IMA or .IMZ)
//  hWnd : parent window for progress window
//  lpFn : FileName
//  lpfCompr : pointer to Boolean (will receive TRUE if file is compressed)
//  dwPosFileBegin : position in file (usualy 0, except in WLZ)
BOOL WIMAAPI ReadImaFile(HIMA hIma,HWND hWnd,LPCSTR lpFn,
                         LPBOOL lpfCompr,DWORD dwPosFileBegin);
BOOL WIMAAPI ReadImaFileEx(HIMA hIma,HWND hWnd,LPCSTR lpFn,
                           LPBOOL lpfCompr,DWORD dwPosFileBegin,
                           LPCSTR lpszPassword);
BOOL WIMAAPI ReadImaFileExCB(HIMA hIma,
                             HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                             LPCSTR lpFn,
                             LPBOOL lpfCompr,DWORD dwPosFileBegin,
                             LPCSTR lpszPassword);
// WriteImaFile : WriteCompressed image
//  hWnd : parent window for progress window
//  lpFn : FileName
//  fTruncate : TRUE if you want truncate unused part of image
//  fCompress : TRUE if you want compress
//  iLevelCompress : used is fCompress is TRUE, level of compress (1 to 9)
//  dwPosBeginWrite : position in file (usualy 0)
//  lpNameInCompr : alternate name in compressed file (can be NULL)
BOOL WIMAAPI WriteImaFile(HIMA hIma,HWND hWnd,LPCSTR lpFn,BOOL fTruncate,
                          BOOL fCompress,int iLevelCompress,
                          DWORD dwPosBeginWrite,LPCSTR lpNameInCompr);

BOOL WIMAAPI WriteImaFileEx(HIMA hIma,HWND hWnd,LPCSTR lpFn,BOOL fTruncate,
                            BOOL fCompress,int iLevelCompress,
                            DWORD dwPosBeginWrite,LPCSTR lpNameInCompr,
                            DWORD dwCryptMethod,LPCSTR lpszPassword);

BOOL WIMAAPI WriteImaFileExCB(HIMA hIma,
                              HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                              LPCSTR lpFn,BOOL fTruncate,
                              BOOL fCompress,int iLevelCompress,
                              DWORD dwPosBeginWrite,LPCSTR lpNameInCompr,
                              DWORD dwCryptMethod,LPCSTR lpszPassword);
//  ReadFloppy : Read a floppy
//  hWnd : parent window for progress window
//  bFloppy : Floppy to read (0 for A:)
//  caRead : USED, or ALL (ALL if you want read unused part of floppy)
BOOL WIMAAPI ReadFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caRead);

// ReadFloppyCB : do not display user interface but call CallBack
BOOL WIMAAPI ReadFloppyCB(HIMA hIma,HWND hWnd,
                          EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                          BYTE bFloppy,CHOICEAPP caRead);

// WriteFloppy : Write a floppy
//  hWnd : parent window for progress window
//  bFloppy : Floppy to write (0 for A:)
//  caFormat : NOTHING or ALL (ALL for format)
//  caWrite : USED or ALL
//  caCompare : NOTHING, USED or ALL
//  fCheckDiskBeforeWrite : if you want check disk is empty
BOOL WIMAAPI WriteFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caFormat,
                         CHOICEAPP caWrite,CHOICEAPP caCompare,
                         BYTE fCheckDiskBeforeWrite);

// WriteFloppyCB : do not display user interface but call CallBack
BOOL WIMAAPI WriteFloppyCB(HIMA hIma,HWND hWnd,
                           EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                           BYTE bFloppy,CHOICEAPP caFormat,
                           CHOICEAPP caWrite,CHOICEAPP caCompare,
                           BYTE fCheckDiskBeforeWrite);



// Create a directory in the image
//  lpDir : Directory name
BOOL WIMAAPI MkDir(HIMA hIma,LPCSTR lpDir);

// Change current directory by name
//  lpDir : Directory name
BOOL WIMAAPI ChszDir(HIMA hIma,LPCSTR lpDir);

// Change current directory by mode
//  bMode : CDM_ROOT or CDM_UPPER (equiv. to cd \ and cd ..)
BOOL WIMAAPI ChDir(HIMA hIma,BYTE bMode);

// Change current directory by mode
//  bMode : CDM_ROOT or CDM_UPPER or CDM_ENTRY (equiv. to cd \ and cd ..)
BOOL WIMAAPI ChDirPos(HIMA hIma,BYTE bMode,DWORD dwPosDir);

// InjectFile : Inject a file in floppy
//  lpFn : file to inject
//  lpDwSize : Pointer to DWORD that will receive the size. Can be NULL.
//  lpTooBig : Pointer to BOOL, become TRUE if file too big to be injected
//      (if InjectFile return FALSE). Can be NULL.
//  lpNameWhenInjected : if not NULL, contain a new name in the image
//      (if the file must have another name when injected). Can be NULL.
//    for the CB version, the only event is DWEV_PROGRESSPERCENT
BOOL WIMAAPI InjectFile(HIMA hIma,LPCSTR lpFn,
                        LPDWORD lpDwSize,LPBOOL lpTooBig,
                        LPCSTR lpNameWhenInjected);

BOOL WIMAAPI InjectFileCB(HIMA hIma,
                          EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                          LPCSTR lpFn,LPDWORD lpDwSize,
                          LPBOOL lpTooBig,LPCSTR lpNameWhenInjected);

// MakeEmptyImage : make an empty image
// iNotypeDisk : 4=720K,6=1440K,7=2880K,8=DMF2048,9=DMF1024,10=1680K
//                  0=160K,1=180K,2=320K,3=360K,5=1200K (old, no ! :-))
BOOL WIMAAPI MakeEmptyImage(HIMA hIma,int iNoTypeDisk);

// MakeEmptyImageEx : make an empty image
// lpszBootSectorGeom : contain a boot sector with the geometry of needed image
// lpszBootSectorCode : contain the boot sector code (can be NULL to standard code)
BOOL WIMAAPI MakeEmptyImageEx(HIMA hIma,LPCSTR lpszBootSectorGeom,LPCSTR lpszBootSectorCode);

// BuildImaNewFormat : Defrag (and pehaps change format)
//   Success: return new Image object (hOldIma is destroyed)
//   Error : Return NULL, hOldIma is not destroyed
// fNewTypeDisk : TRUE: change format using iNotypeDisk, FALSE: Just defrag
// iNotypeDisk : 4=720K,6=1440K,7=2880K,8=DMF2048,9=DMF1024,10=1680K
//                  0=160K,1=180K,2=320K,3=360K,5=1200K (old, no ! :-))
HIMA WIMAAPI BuildImaNewFormat(HIMA hOldIma,BOOL fNewTypeDisk,int iNoTypeDisk);


// BuildImaNewFormat : Defrag (and pehaps change format)
// hNewIma will receive the new image and must have been created
// lpszBootSectForGeometry : contain a boot sector with geometry of new image
// fDiscardOldIma : TRUE to delete hOldIma (if BuildImaNewFormatEx has success)
BOOL WIMAAPI BuildImaNewFormatEx(HIMA hOldIma,HIMA hNewIma,BOOL fNewTypeDisk,
                                 LPCSTR lpszBootSectForGeometry,BOOL fDiscardOldIma);


BOOL WIMAAPI BuildImaNewFormatExCB(HIMA hOldIma,HIMA hNewIma,
                                   EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                   BOOL fNewTypeDisk,
                                   LPCSTR lpszBootSectForGeometry,BOOL fDiscardOldIma);



// Create an empty FAT16 image file, by specifying number of sector and number of root entry
//   This API is supported, but obsolete (MakeEmptyImageEx is better)
BOOL WIMAAPI BuildFat16EmptyImageFromSize(LPCTSTR lpszFileName,DWORD dwNbSector,DWORD dwNbRootEntry);


// InitWimaSdk : Init the DLL and use hinstdll for resource
#define DEBENUSTD "ENU"
#define BASEENUSTD (10000)
// default lpDeb value is "ENU" and wBase is BASEENUSTD
BOOL WIMAAPI InitWimaSdk(HINSTANCE hinstdll,LPCSTR lpDeb,WORD wBase);

// GetCurDir : Get the name of current directory
//  lpBuf : buffer that will receive the name
//  uiMaxSize : the size of buffer
BOOL WIMAAPI GetCurDir(HIMA hIma,LPSTR lpBuf,UINT uiMaxSize);

// GetNbEntryCurDir : Get the number of entry of cur directory
DWORD WIMAAPI GetNbEntryCurDir(HIMA hIma);

// GetDirInfo : Get info about the entry of cur directory
//  LPDIRINFO : array of DIRINFO that will receive the info
//                  (use GetNbEntryCurDir for know the size needed)
//  bSort :     specify how the file must be sort
//          (SORT_NONE, SORT_NAME, SORT_EXT, SORT_SIZE or SORT_DATE)
BOOL WIMAAPI GetDirInfo(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);

// Sort : Resort the array obtained by GetDirInfo
BOOL WIMAAPI Sort(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);


BOOL WIMAAPI RefreshInternalBufferDirInfo(HIMA hIma,BYTE bSort,LPDWORD lpdwNumberItem);

BOOL WIMAAPI GetBufferDirInfoItem(HIMA hIma,LPDIRINFO lpdiItem,DWORD dwItemPos);

BOOL WIMAAPI ReSortBufferDirInfo(HIMA hIma,BYTE bSort);

// GetLabel : Get the label of Image
//  lpBuf : will receive the label
BOOL WIMAAPI GetLabel(HIMA hIma,LPSTR lpBuf);

// SetLabel : Set the label of Image
//  lpBuf : contain the new label
BOOL WIMAAPI SetLabel(HIMA hIma,LPCSTR lpBuf);

// ExtractFile : Extract one file
//  uiPosDir :  The uiPosInDir fields in DIRINFO structure that describe
//                  the file
//  lpPath :    Path where extract the file
//  lpFullName: will receive the exact full name of created file. Can be NULL
//    for the CB version, the only event is DWEV_PROGRESSPERCENT
BOOL WIMAAPI ExtractFile(HIMA hIma,DWORD dwPosDir,LPCSTR lpPath,LPSTR lpFullName);

BOOL WIMAAPI ExtractFileCB(HIMA hIma,
                           EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                           DWORD dwPosDir,LPCSTR lpPath,LPSTR lpFullName);

BOOL WIMAAPI ExtractFileVirtual(HIMA hIma,
                                  FILEIOCALLBACK pFileIoCallBack,DWORD dwMaxVirtualBufSize,LPVOID lpParamUsrExtractOut,
                                  DWORD dwPosDir,LPCSTR lpPath,LPSTR lpFullName);

BOOL WIMAAPI ExtractFileVirtualCB(HIMA hIma,
                                  FILEIOCALLBACK pFileIoCallBack,DWORD dwMaxVirtualBufSize,LPVOID lpParamUsrExtractOut,
                                  EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                  DWORD dwPosDir,LPCSTR lpPath,LPSTR lpFullName);

// CheckSpaceForFile : Check you've space for inject a file of dwSize bytes
BOOL WIMAAPI CheckSpaceForFile(HIMA hIma,DWORD dwSize);

// to know if an inject is possible but need replace
//  lpFn : contain the name of file to be injected
//  lpDwSize : will receive the size of old file with same name. Can be NULL
//  lpNameWhenInjected : if not NULL, contain a new name in the image
//  lpShortName : will receive the short (8) name of file in image. Can be NULL
//  lpShortExt  : will receive the short (3) ext of file in image. Can be NULL
//      (if the file must have another name when injected)
BOOL WIMAAPI IfInjectPossibleButNeedReplace(HIMA hIma,LPCSTR lpFn,
         LPDWORD lpDwSize,LPSTR lpShortName,
         LPSTR lpShortExt,LPCSTR lpNameWhenInjected);

// RmDir : Remove a directory
//  unPosDir :  The uiPosInDir fields in DIRINFO structure that describe
//                  the file
BOOL WIMAAPI RmDir(HIMA hIma,UINT uiPosDir);

// DeleteFileNameExt
//   Delete a file in the image
//     for filling lpNom and lpExt, use data obtained from GetDirInfo
//   lpNom : pointer to array of 8 chars (name of 8.3 name, use DIRINFO.nom)
//   lpExt : pointer to array of 3 chars (ext  of 8.3 name, use DIRINFO.ext)
//   fRealDel : TRUE to really delete, FALSE to only test if delete is possible
BOOL WIMAAPI DeleteFileNameExt(HIMA hIma,LPCSTR lpNom,LPCSTR lpExt,BOOL fRealDel);


// MoveFileToDir
//    Move a file from current directory to another directory
//     for filling lpNom and lpExt, use data obtained from GetDirInfo
//   lpName: pointer to array of 8 chars (name of 8.3 name, use DIRINFO.nom)
//   lpExt : pointer to array of 3 chars (ext  of 8.3 name, use DIRINFO.ext)
//   lpszDestDir : string contained the path of new directory (like "dir1\\dir2")
//   lpfReplaceNeeded : will receive TRUE if we need replace an existing file
//   fDoRealMove : TRUE to really delete, FALSE to only test if move is possible
//   fDoReplaceIfNeeded : TRUE to to the move if we need replace an existing file
//          (ignored if replace is not needed)
//   lpdwErrInfo : will receive a ERRINFO_MOVEFILE_* if there is error with lpszDestDir
#ifndef ERRINFO_MOVEFILE_DESTINATIONEQUALSOURCE
#define ERRINFO_MOVEFILE_DESTINATIONEQUALSOURCE     ((DWORD)(0x80000001UL))
#define ERRINFO_MOVEFILE_DESTINATIONSUBFOLERDEPL    ((DWORD)(0x80000002UL))
#endif

BOOL WIMAAPI MoveFileToDir(HIMA hIma,LPCSTR lpName,LPCSTR lpExt,LPCSTR lpszDestDir,
                           LPBOOL lpfReplaceNeeded,BOOL fDoRealMove,BOOL fDoReplaceIfNeeded,
                           LPDWORD lpdwErrInfo);


// RenameFile :    Rename one file
//  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
//                  the file
//  lpNewLongName: The new name of the file
BOOL RenameFile(HIMA hIma,UINT uiPosDir,LPCSTR lpNewLongName);


// ChangeDateAndAttribute :    Change the date and attribute of a File
//  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
//                  the file
//  *lpbNewAttr:   Contain the new attribute of the file (or NULL to no change)
//  *lpNewDosDate,
//  *lpNewDosTime: Contain the Modified Date and Time (or NULL to no change)
//  *lpbNewdir_CreateMSec,*lpwNewdir_CreateTime,*lpwNewdir_CreateDate
//                 Contain the Created Date and Time (or NULL to no change)
//  *lpwNewdir_LastAccessDate : Contain the Last Access Date (or NULL...)
BOOL ChangeDateAndAttribute(HIMA hIma,UINT uiPosDir,LPBYTE lpbNewAttr,
                                    LPWORD lpNewDosDate,LPWORD lpNewDosTime,
                                    LPBYTE lpbNewdir_CreateMSec,
                                    LPWORD lpwNewdir_CreateTime,LPWORD lpwNewdir_CreateDate,
                                    LPWORD lpwNewdir_LastAccessDate);


// ReadData : Direct read data in image.
//  dwPos :  begin position
//  dwSize : number of byte to copy (size of buffer)
//  lpBuf :  buffer that will receive data
BOOL WIMAAPI ReadData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPSTR lpBuf);

// WriteData : Direct write data in image. Be carreful, WI don't refresh dir!
//  dwPos :  begin position
//  dwSize : number of byte to copy (size of buffer)
//  lpBuf :  buffer that contain data
BOOL WIMAAPI WriteData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPCSTR lpBuf);
/* */

//
// GetFatImaSizeFileName : Get information about UNCOMPRESSED Fat image
//   lpfn :          FileName
//   lpdwSize :      Will receive the size of the image, 32 bits low part of 64 bit data
//   lpdwSize!high : Will receive the size of the image, 32 bits high part of 64 bit data
//   lpfIsBigFat :   Boolean pointer, will receive TRUE if this is a large image (>2.88MB), not floppy image
//   lpdwPosInFile : Will receive the position of the image
BOOL WIMAAPI GetFatImaSizeFileName(LPCSTR lpFn,LPDWORD lpdwSize,LPDWORD lpdwSizeHigh,LPBOOL lpfIsBigFat,LPDWORD lpdwPosInFile);


// GetDriveInfo : Get info about drive type
//  bDrive : number of driver (0 = 'A:', 1 = 'B:')
//  return the kind of drive
DRIVEINFO WIMAAPI GetDriveInfo(BYTE bDrive);

typedef struct
{
    DWORD dwSizeStruct;
    DWORD dwHost;
    DWORD dwTargetID;
    DWORD dwTargetType;
    char  szDeviceName[32];
} ASPIINQUIRYTAB;

// Fill the ASPI Inquiry array.
// if lpAspiCdRomInquityTab is NULL AND dwMaxNumberInArray==0, just return the number of ASPI CDrom Unit.
//  lpAspiCdRomInquityTab : Will receive the Array of SCSI Unit
//  dwMaxNumberInArray : size of array (in number of ASPIINQUIRYTAB)
DWORD WIMAAPI WimLargeAspiCdromInquiryFillArray(ASPIINQUIRYTAB* lpAspiCdRomInquityTab,DWORD dwMaxNumberInArray);

// Create a CDRom Image fro ASPI Unit, using dwHost and dwTargetID from AspiCdromInquiy
//   lpFn : Filename to create
//   lpdwTotal : will receive the filesize
// Note : I suggest using WimLargeReadAspiCDImageIgnoreError with fIgnoreError at FALSE
BOOL WIMAAPI WimLargeReadAspiCDImage(HWND hWnd,DWORD dwHost,DWORD dwTargetID,LPSTR lpFn,LPDWORD lpdwTotal);


// Like WimLargeReadAspiCDImage
// fIgnoreError :
//    FALSE : if there is error ignore it only if the error is after ISO9660 size (suggested)
//    TRUE : Ignore all ISO 9660 error
BOOL WIMAAPI WimLargeReadAspiCDImageIgnoreError(HWND hWnd,DWORD dwHost,DWORD dwTargetID,
                                                LPSTR lpFn,LPDWORD lpdwTotal,BOOL fIgnoreError);

BOOL WIMAAPI WimLargeReadAspiCDImageIgnoreErrorCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                                  DWORD dwHost,DWORD dwTargetID,
                                                  LPSTR lpFn,LPDWORD lpdwTotal,BOOL fIgnoreError);

// return value != 0 if WimLargeReadLargeIma can be used with CDRom
// (elsewhere, only hard disk partition)
DWORD WIMAAPI WimLargeIsReadImaIsoPossible();

// Read Disk partition to image
//  cDrive : disk letter ('C' for disk C:...)
//  lpdwTotal : will receive number of byte processed
//  caRead : USED, or ALL (ALL if you want read unused part of disk)
BOOL WIMAAPI WimLargeReadLargeIma(HWND hWnd,char cDrive,LPSTR lpFn,LPDWORD lpdwTotal,CHOICEAPP caRead);

BOOL WIMAAPI WimLargeReadLargeImaCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                    char cDrive,LPSTR lpFn,LPDWORD lpdwTotal,CHOICEAPP caRead);

BOOL WIMAAPI WimLargeReadLargeImaEx(HWND hWnd,char cDrive,LPSTR lpFn,
                                    LPDWORD lpdwTotal,LPDWORD lpdwTotalHigh,CHOICEAPP caRead);

BOOL WIMAAPI WimLargeReadLargeImaCBEx(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                    char cDrive,LPSTR lpFn,
                                    LPDWORD lpdwTotal,LPDWORD lpdwTotalHigh,CHOICEAPP caRead);

// Write Disk partition from image
//  cDrive : disk letter ('C' for disk C:...)
//  lpdwTotal : will receive number of byte processed
//  lpdwTotal : will receive high part of number of byte processed
//  caWrite : USED or ALL
//  fCheckDiskBeforeWrite : if you want check disk is empty
//  fAcceptAdapt : if geometry is incompatible and fAcceptAdapt is TRUE, adapt geometry
//          if geometry is incompatible and fAcceptAdapt is FALSE, return only FALSE
BOOL WIMAAPI WimLargeWriteLargeIma(HIMA hIma,HWND hWnd,char cDrive,LPDWORD lpdwTotal,
                                   CHOICEAPP caWrite,BOOL fCheckDiskBeforeWriteThis);

BOOL WIMAAPI WimLargeWriteLargeImaCB(HIMA hIma,
                                     HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                     char cDrive,LPDWORD lpdwTotal,
                                     CHOICEAPP caWrite,BOOL fCheckDiskBeforeWriteThis);

BOOL WIMAAPI WimLargeWriteLargeImaEx(HIMA hIma,HWND hWnd,char cDrive,
                                     LPDWORD lpdwTotal,LPDWORD lpdwTotalHigh,
								     CHOICEAPP caWrite,BOOL fCheckDiskBeforeWriteThis,
                                     BOOL fAcceptAdapt,LPBOOL lpfGeometryIncompatible);

BOOL WIMAAPI WimLargeWriteLargeImaCBEx(HIMA hIma,
                                     HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                     char cDrive,LPDWORD lpdwTotal,LPDWORD lpdwTotalHigh,
                                     CHOICEAPP caWrite,BOOL fCheckDiskBeforeWriteThis,
                                     BOOL fAcceptAdapt,LPBOOL lpfGeometryIncompatible);

// say if a letter if a CDRom
BOOL WIMAAPI WimLargeIsIsoCDDrive(char cDrive);

// Write the boot sector of an image
BOOL WIMAAPI WriteSectBoot(HIMA hIma,const BYTE*  lpBuf,DWORD dwSizeBuf);

// Read the boot sector of an image
BOOL WIMAAPI GetSectBoot(HIMA hIma,BYTE* lpBuf,DWORD dwSizeBuf,LPDWORD lpdwSizeBoot);

// Get the total size of an image
BOOL WIMAAPI GetImageSize(HIMA hIma,LPDWORD lpdwLow,LPDWORD lpdwHigh);

// Get the free space in an image
BOOL WIMAAPI GetFreeSpaceInImage(HIMA hIma,LPDWORD lpdwLow,LPDWORD lpdwHigh);


// IsFileExportableRawStandard, ExportRawStandardFile for export not .iso CDRom (like .bin) to .iso image
BOOL WIMAAPI IsFileExportableRawStandard(HIMA hIma,LPBOOL lpfUsefulExport,
                                         LPDWORD lpdwSizeIsoFileLow,LPDWORD lpdwSizeIsoFileHigh);

BOOL WIMAAPI ExportRawStandardFile(HIMA hIma,HWND hWnd,
                                   LPCSTR lpszIsoFileName);

BOOL WIMAAPI ExportRawStandardFileCB(HIMA hIma,HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                     LPCSTR lpszIsoFileName);


///
typedef struct
{
BYTE bActivate;
BYTE bHeadBegin;
WORD wCylSectBegin;

BYTE bType;  // 0=none, 5=ext
BYTE bHeadEnd;
WORD wCylSectEnd;

DWORD dwDist;
DWORD dwSize;
} PARTITION;

typedef struct
{
PARTITION part;
DWORD dwPos;
DWORD dwPosPartition;
BOOL fIsFat32;
BOOL fIsFat;
BOOL fIsNtfs;
BOOL fIsLinux;
BYTE bDisk;
BYTE bFill[3];
} PARTDESC;
typedef PARTDESC* PPARTDESC;

#define PARTITION_DEFINED

DWORD WIMAAPI MakePartitionList(LPCSTR lpfn,LPCSTR lpszPassword,
                           DWORD*pdwNbPartFound,DWORD *pdwNbFat32Found,
                           DWORD dwArraySize,PARTDESC* pList);



DWORD WIMAAPI GetNumberPhysicalDisk();

BOOL WIMAAPI GetPhysicalDiskSizeAndInfo(DWORD dwDisk,LPDWORD lpdwSizeLow,LPDWORD lpdwSizeHigh,
                                 LPBOOL lpfRemovable,
                                 LPTSTR lpszUnitName,DWORD dwUnitNameSize);

typedef enum
{
    PHYSICALDISKIMAGEFORMAT_UNKNOWN = 0,
    PHYSICALDISKIMAGEFORMAT_FIXED,
    PHYSICALDISKIMAGEFORMAT_VHDFIXED,
    PHYSICALDISKIMAGEFORMAT_VHDDYNAMIC,
    PHYSICALDISKIMAGEFORMAT_VMDKFIXED,
    PHYSICALDISKIMAGEFORMAT_VMDKDYNAMIC,
} PHYSICALDISKIMAGEFORMAT;

// Create image of a physical disk of a virtual file

BOOL WIMAAPI CreatePhysicalDiskImage(HWND hWnd,DWORD dwDisk,LPCSTR lpFn,PHYSICALDISKIMAGEFORMAT PhysFormat);


BOOL WIMAAPI CreatePhysicalDiskImageCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                       DWORD dwDisk,LPCSTR lpFn,PHYSICALDISKIMAGEFORMAT PhysFormat);

BOOL WIMAAPI RestorePhysicalDiskImage(HWND hWnd,DWORD dwDisk,LPCSTR szFile);

BOOL WIMAAPI RestorePhysicalDiskImageCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                        DWORD dwDisk,LPCSTR szFile);

BOOL WIMAAPI ConvertVhdImgFileName(HWND hWnd,LPCSTR szFileRead,LPCSTR lpFilenameParamWrite,PHYSICALDISKIMAGEFORMAT PhysFormat);


BOOL WIMAAPI ConvertVhdImgFileNameCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
                                     LPCSTR szFileRead,LPCSTR lpFilenameParamWrite,PHYSICALDISKIMAGEFORMAT PhysFormat);


#ifdef __cplusplus
}
#endif  /* __cplusplus */
