#include <stdlib.h>
#include <string.h>

#include <windows.h>
#include <windowsx.h>

#include "wimadll.h"
#include "resource.h"

HINSTANCE ghInstance=NULL;

static BOOL IsFloppyDrive(int iFloppy)
{
    DRIVEINFO driveInfo = GetDriveInfo((BYTE)iFloppy);
    if ((driveInfo==FLOPPY_360) || (driveInfo==FLOPPY_12M) ||
        (driveInfo==FLOPPY_720) || (driveInfo==FLOPPY_144) ||
        (driveInfo==FLOPPY_288))
        return TRUE;
    return FALSE;
}

static void FillComboFloppy(HWND hwndCombo)
{
int iIndex,i;
  ComboBox_ResetContent(hwndCombo);
  for (i=0;i<26;i++)
    if (IsFloppyDrive(i))
     {
     char szDrive[10] = "::";
       szDrive[0] = i + 'A';
       iIndex = ComboBox_AddString(hwndCombo,(LPSTR)szDrive);
       ComboBox_SetItemData(hwndCombo,iIndex,i);
       ComboBox_SetCurSel(hwndCombo, 0);
     }
}

static void LoadFilter(HINSTANCE hInst,WORD wId,PSTR pFilter,int sz)
{
char c;
   LoadString(hInst,wId,pFilter,sz-2);
   while ((c=(*pFilter)) != '\0')
     {
       if (c == '|') *pFilter = '\0';
       pFilter++;
     }
   *(pFilter) = '\0';  
   *(pFilter+1) = '\0';
}               

static void InitOpenFileName(HINSTANCE hInst,OPENFILENAME * pofn,HWND hWnd,
                    WORD wIdFilter,PSTR pFilter,int szFilter,
                    LPSTR lpstrFile,DWORD dwSizeFile,
                    LPSTR lpCapt,WORD wIdCapt,int szCapt)
{
   _fmemset(pofn, 0, sizeof(OPENFILENAME));

   LoadFilter(hInst,wIdFilter,pFilter,szFilter);
   pofn->lStructSize = sizeof(OPENFILENAME);
   pofn->hwndOwner = hWnd;
   pofn->lpstrFilter = pFilter ;
   pofn->nFilterIndex = 1;
   pofn->lpstrFile = lpstrFile;
   pofn->nMaxFile = dwSizeFile;

   if (wIdCapt != 0)
     {
       LoadString(hInst,wIdCapt,lpCapt,szCapt);
       pofn->lpstrTitle = lpCapt;
     }

   pofn->Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

}




static BOOL GetOpenImaFN(HWND hDlg,LPSTR lpFn,int iFnSize)
{
OPENFILENAME ofn;
char szFilter[256];
char szExt[16];

lstrcpy(szExt,"");
InitOpenFileName(ghInstance,&ofn,hDlg,IDS_TYPEOPENIMASFX,szFilter,sizeof(szFilter)-1,
                          lpFn,iFnSize,NULL,0,0);
  ofn.lpstrDefExt=szExt;

  ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY |
               OFN_OVERWRITEPROMPT | OFN_FILEMUSTEXIST ;
               
  if (!GetOpenFileName(&ofn)) return FALSE; 
  return TRUE;
}


/*****************************************************************************************************/
// This portion contain the real WinImage SDK work

static HIMA TryLoadFloppyIma(LPCSTR lpszImageFileName)
{
    BOOL fCompr=FALSE;
    HIMA hIma = CreateMemFatHima();
    if (hIma!=NULL)
    {
        if (!ReadImaFile(hIma,/*NULL*/HWND_NO_PROGRESS,(LPSTR)lpszImageFileName,&fCompr,0))
        {
            DeleteIma(hIma);
            hIma=NULL;
        }
    }
    return hIma;
}

BOOL DoWrFlop(HWND hWnd,LPCSTR lpszImageFileName,BYTE bFloppy,BOOL fFormat)
{
    BOOL fResult=FALSE;
    HIMA hIma=TryLoadFloppyIma(lpszImageFileName);

    if (hIma!=NULL)
    {
        fResult=WriteFloppy(hIma,hWnd,bFloppy,fFormat ? ALL:NOTHING,ALL,ALL,TRUE);
        DeleteIma(hIma);
    }
    return fResult;
}

BOOL CALLBACK WrFlopDlgProc(HWND hDlg,UINT message,
                            WPARAM wParam,LPARAM lParam)
{
  switch (message)
    {
        case WM_INITDIALOG:                /* message: initialize dialog box */
            FillComboFloppy(GetDlgItem(hDlg,IDC_FLOPPYLIST));
            return (TRUE);

        case WM_COMMAND:
            switch (GET_WM_COMMAND_ID(wParam,lParam))
               {
                case IDC_BROWSE:
                    {
                        char szText[MAX_PATH+1]="";
                        GetDlgItemText(hDlg,IDC_EDITFILENAME,szText,sizeof(szText)-1);
                        if (GetOpenImaFN(hDlg,szText,sizeof(szText)-1))
                            SetDlgItemText(hDlg,IDC_EDITFILENAME,szText);
                    }
                    break;

                case IDOK:
                    {
                        BOOL fFormat;
                        BYTE bFloppy;
                        BOOL fResult;
                        char szText[MAX_PATH+1]="";
                        HWND hWndCombo=GetDlgItem(hDlg,IDC_FLOPPYLIST);

                        GetDlgItemText(hDlg,IDC_EDITFILENAME,szText,sizeof(szText)-1);
                        fFormat=IsDlgButtonChecked(hDlg,IDC_FMTFLOPPY) != BST_UNCHECKED;
                        bFloppy=(BYTE)ComboBox_GetItemData(hWndCombo,ComboBox_GetCurSel(hWndCombo));
                        fResult=DoWrFlop(hDlg,szText,bFloppy,fFormat);

                        {
                            char szText[256];
                            char szCaption[256];
                            LoadString(ghInstance,fResult ? IDS_RESULTOK:IDS_RESULTERROR,szText,sizeof(szText)-1);
                            LoadString(ghInstance,IDS_CAPTION,szCaption,sizeof(szCaption)-1);
                            MessageBox(hDlg,szText,szCaption,(fResult ? MB_ICONINFORMATION : MB_ICONSTOP)|MB_OK);
                        }
                        
                        EndDialog(hDlg,fResult);
                        return TRUE;
                    }

                case IDCANCEL:
                    EndDialog(hDlg,FALSE);
                    return TRUE;
               }

    }
  return FALSE;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
{
    ghInstance=hInstance;
    return DialogBox(hInstance,MAKEINTRESOURCE(IDD_WRFLOP),NULL,WrFlopDlgProc);
}
