/*

Gilles Vollant
info@winimage.com
*/


#ifdef __cplusplus
extern "C"
{
#endif

#ifndef VMDKDLLFILENAMECHAR_DEFINED
#define VMDKDLLFILENAMECHAR_DEFINED
typedef TCHAR VMDKDLLFILENAMECHAR;
#endif

DECLARE_VMDKHANDLE(VMDKFILE_HANDLE);
typedef enum
{
    VMDK_SUPPORT_NOT_IMPLEMENTED,
    VMDK_IOERROR,
    VMDK_NOTVMDKFILE,
    VMDK_BADPARENT,
    VMDK_OPENABLEVMDKFILE
} VMDK_FILE_KIND;


/*
this function try open a .VMDK file
if pvmdkHandle == NULL, it try only open the VMDK file to check if this is VMDK file
if the return value is VMDK_OPENABLEVMDKFILE, we known this is a valid VMDK
if pvmdkHandle != NULL, it really open the VMDK file and store handle on *pvmdkHandle if success
This handle will be used in all other function

fAcceptFullRawWithoutHeader : TRUE to accept a full RAW file (like the PFR raw file) without VMDK header
lpdwError: *lpdwError will receive a Win32 error code (like GetLastError() API)
fReadOnly : TRUE to open as Read only
*/

VMDK_FILE_KIND OpenVmdkFile(const VMDKDLLFILENAMECHAR* lpFileName,
                          VMDKMEMORY_BOOL fAcceptFullRawWithoutHeader,
                          VMDKFILE_HANDLE * pvmdkHandle,
                          VMDKMEMORY_UINT4* lpdwError, VMDKMEMORY_BOOL fReadOnly);

VMDK_FILE_KIND OpenVmdkFileA(const char* lpFileName,
                          VMDKMEMORY_BOOL fAcceptFullRawWithoutHeader,
                          VMDKFILE_HANDLE * pvmdkHandle,
                          VMDKMEMORY_UINT4* lpdwError, VMDKMEMORY_BOOL fReadOnly);

VMDK_FILE_KIND OpenVmdkFileW(const unsigned short* lpFileName,
                          VMDKMEMORY_BOOL fAcceptFullRawWithoutHeader,
                          VMDKFILE_HANDLE * pvmdkHandle,
                          VMDKMEMORY_UINT4* lpdwError, VMDKMEMORY_BOOL fReadOnly);

/*
normaly read/write function. Return the number of byte of the operation
lpdwError: *lpdwError will receive a Win32 error code (like GetLastError() API)
*/

VMDKMEMORY_UINT4 ReadVmdk(VMDKFILE_HANDLE vmdkHandle,void* buf,VMDKMEMORY_UINT8 pos, VMDKMEMORY_UINT4 size, VMDKMEMORY_UINT4* lpdwError);
VMDKMEMORY_UINT4 WriteVmdk(VMDKFILE_HANDLE vmdkHandle,const void* buf,VMDKMEMORY_UINT8 pos, VMDKMEMORY_UINT4 size, VMDKMEMORY_UINT4* lpdwError);

/*
Return the size of the image (not the size of the VMDK file, but the size of virtual disk)
*/
VMDKMEMORY_UINT8 GetVmdkSize(VMDKFILE_HANDLE vmdkHandle,VMDKMEMORY_UINT4* lpdwError);

/*
Close the handle
*/
VMDKMEMORY_BOOL CloseVmdk(VMDKFILE_HANDLE vmdkHandle,VMDKMEMORY_UINT4* lpdwError);


/*
if the VMDK file uses RAW storage (with or without header), return TRUE
*pShift will receive the size of the header BEFORE the raw data (usually 0 with fixed VMDK file)
*/
//VMDKMEMORY_BOOL GetRawFixedDataShift(VMDKFILE_HANDLE vmdkHandle,VMDKMEMORY_UINT8*pShift,VMDKMEMORY_UINT4* lpdwError);



VMDKMEMORY_BOOL BuildEmptyVmdkFile(const void*lpFileName,VMDKMEMORY_BOOL fNameUnicode,VMDKMEMORY_UINT4* lpdwError,
                                   VMDKMEMORY_UINT4 dwCid,
                                   VMDKMEMORY_UINT4 dwNbSector,const char* lpszNameInDescriptor,
                                   VMDKMEMORY_UINT4 dwCylinders,VMDKMEMORY_UINT4 dwHeads,VMDKMEMORY_UINT4 dwSectorsGeom,
                                   const char* lpszDescriptorType);

VMDKMEMORY_BOOL BuildEmptyVmdkFileA(const char*lpFileName,VMDKMEMORY_BOOL fNameUnicode,VMDKMEMORY_UINT4* lpdwError,
                                   VMDKMEMORY_UINT4 dwCid,
                                   VMDKMEMORY_UINT4 dwNbSector,const char* lpszNameInDescriptorParam,
                                   VMDKMEMORY_UINT4 dwCylinders,VMDKMEMORY_UINT4 dwHeads,VMDKMEMORY_UINT4 dwSectorsGeom,
                                   const char* lpszDescriptorType);

VMDKMEMORY_BOOL BuildEmptyVmdkFileW(const unsigned short*lpFileName,VMDKMEMORY_BOOL fNameUnicode,VMDKMEMORY_UINT4* lpdwError,
                                   VMDKMEMORY_UINT4 dwCid,
                                   VMDKMEMORY_UINT4 dwNbSector,const char* lpszNameInDescriptorParam,
                                   VMDKMEMORY_UINT4 dwCylinders,VMDKMEMORY_UINT4 dwHeads,VMDKMEMORY_UINT4 dwSectorsGeom,
                                   const char* lpszDescriptorType);
#ifdef __cplusplus
}
#endif
