using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;



namespace CSConsoleSample
{
    class Program
     {
     
        private static int WimExtractCB(uint dwEvent, uint dwEventParam, uint dwWin32Err, int lpParam, int lpUserParam)
        {
            switch (dwEvent)
            {
                case Wimadll.DWEV_PROGRESSPERCENT:
                    Console.Write("\x08\x08\x08\x08\x08");
                    string str = dwEventParam.ToString();
                    if (str.Length < 2)
                        str = "0" + str;
                    if (str.Length < 3)
                        str = " " + str;
                    Console.Write(str);
                    Console.Write(" %");
                    break;
            };
            return 0;
        }

        static void ProcessDirectory(IntPtr hima, string curdir, string prefixline, bool fIsSubDir, string file_to_extract, string path_to_extract)
        {
            Console.Write("list content of directory : ");
            Console.Write(curdir);
            Console.WriteLine("");
            int dwNumberItem = 0;
            int j,k ;
            byte bSortDisplay=Wimadll.SORT_NAME;
            Wimadll.RefreshInternalBufferDirInfo(hima, bSortDisplay, ref dwNumberItem);
            for (j = 0; j < dwNumberItem; j++)
            {
                string strname;
                Wimadll.DIRINFO di=new Wimadll.DIRINFO ();
                Wimadll.GetBufferDirInfoItem(hima, ref di, j);
                strname = new string(di.longname);
                int i_pos_end = strname.IndexOf('\0');
                if (i_pos_end > 0)
                {
                    strname = strname.Remove(i_pos_end);
                }
                Console.Write(prefixline);
                Console.Write(strname);
                for (k=strname.Length;k<60-prefixline.Length;k++)
                    Console.Write(" ");
                if (di.fIsSubDir)
                {
                    Console.Write("<DIR>");

                    Console.WriteLine("");
                    if ((!fIsSubDir) || ((strname!=".") && (strname!="..")))
                    {
                        bool chres = Wimadll.ChDirPos(hima, Wimadll.CDM_ENTRY, (int)di.uiPosInDir);
                        ProcessDirectory(hima, curdir + strname + "\\", prefixline + " ", true, file_to_extract, path_to_extract);
                        Wimadll.ChDir(hima, Wimadll.CDM_UPPER);
                        Wimadll.RefreshInternalBufferDirInfo(hima, bSortDisplay, ref dwNumberItem);
                    }
                }
                else
                {
                    Console.Write(di.dwSize);
                    Console.WriteLine("");
                    if (String.Compare(strname,file_to_extract,true)==0)
                    {
                        Console.Write("--> extracting :         ");
                        StringBuilder nameCreated = new StringBuilder(16);
                        Wimadll.WimCB ExtractCBFunc = new Wimadll.WimCB ( WimExtractCB);
                        Wimadll.ExtractFileCB(hima, ExtractCBFunc,new IntPtr(),di.uiPosInDir, path_to_extract, nameCreated);
                        Console.Write(" File created : ");
                        Console.Write(nameCreated.ToString());
                        Console.WriteLine("");
                    }
                }

            }
        }

        static void processpartition(string filename, Wimadll.PARTDESC partdesc, int numpart_show, string file_to_extract, string path_to_extract)
        {
            IntPtr hima;            
            hima = Wimadll.OpenLargeImageFile(new IntPtr(0), filename, partdesc.dwPosPartition * 512, partdesc.dwPosPartition / (0x1000000 / 2), true);
            if (hima.ToInt64() != 0)
            {
                Console.Write("opened partition number ");
                Console.Write(numpart_show);

                StringBuilder sLabel = new StringBuilder(16);
                Wimadll.GetLabel(hima, sLabel);
                Console.Write("  Label: ");
                Console.WriteLine(sLabel.ToString());

                ProcessDirectory(hima, "", "", false, file_to_extract, path_to_extract);
                Wimadll.DeleteIma(hima);
            }
            else
            {
                Console.WriteLine("unable to open file");
            }
            Console.WriteLine("");
        }


        static void processfile(string filename, string file_to_extract,string path_to_extract)
        {

            int dwNbFat32Found = 0;
            int dwNbPartFound = 0;
            int retMakelist=0;
            int i;
            Wimadll.PARTDESCArray pdar = new Wimadll.PARTDESCArray();
            retMakelist = Wimadll.MakePartitionList(filename, "", ref dwNbPartFound, ref dwNbFat32Found, 32, ref pdar);
            Console.Write("number of partition = ");
            Console.Write(retMakelist);
            Console.WriteLine("");

            for (i = 0; i < retMakelist; i++)
            {
                processpartition(filename, pdar.partItem[i], i, file_to_extract, path_to_extract);
            }
        }

        static void Main(string[] args)
        {
            if (args.Length == 0)
            {
                Console.WriteLine("CsConsoleSample : C# sample of WinImage SDK");
                Console.WriteLine("");
                Console.WriteLine("usage:");
                Console.WriteLine("CsConsoleSample <big_image_file> [filename_to_extract] [location_to_extract]");
                Console.WriteLine("where:");
                Console.WriteLine("  big_image_file : full pathname of an uncompressed drive image. Can be");
                Console.WriteLine("     Virtual PC/Server VHD file or VMWare VMDK file");
                Console.WriteLine("  filename_to_extract (optional) : a filename you want extract (without wildcard)");
                Console.WriteLine("  location_to_extract (optional) : path where you want extract");

            }
            else
            {
                Console.Write("processing file :");
                Console.Write(args[0]);
                Console.WriteLine("");

                if (args.Length > 1)
                {
                    if (args.Length > 2)
                        processfile(args[0], args[1],args[2]);
                    else
                        processfile(args[0], args[1],".");
                }
                else
                    processfile(args[0], "",".");
            }
        }
    }
}