/*
As the Microsoft licence is very restrictive, be carreful before use it about what
is possible (by example, it seem we must specify in the agreement with Microsoft
what product will use it, and it must provide no API).
you can contact vhdlic@microsoft.com


This is pure C code, without using C runtime or Windows API in the main code (vhdAcces.c), 
because pehaps I'll use it on driver a day (like Filedisk). So it is very portable.


vhdAcces.c : the main VHD engine
vhdLowFn.c and vhdTool.c : low level code used by vhdAccess.c, which is platform dependent
vhdTest.c : a very simple sample.

vhdAcces.h : the "public" function of my library
vhdType.h : the "public" type of the library
vhdAccIn.h: internal header and structure
vhdTool.h: internal function header for vhdTool.c, used only by vhdAcces.c
vhdLowFn.h: internal function header for vhdLowFn.c, used only by vhdAcces.c


an application which use VHD need include vhdType.h and then vhdAcces.h

Gilles Vollant
info@winimage.com
*/


#ifdef __cplusplus
extern "C"
{
#endif

#ifndef VHDLLFILENAMECHAR_DEFINED
#define VHDLLFILENAMECHAR_DEFINED
typedef TCHAR VHDLLFILENAMECHAR;
#endif

DECLARE_VHDHANDLE(VHDFILE_HANDLE);
typedef enum
{
    VHD_SUPPORT_NOT_IMPLEMENTED,
    VHD_IOERROR,
    VHD_NOTVHDFILE,
    VHD_OPENABLEVHDFILE
} VHD_FILE_KIND;


/*
this function try open a .VHD file
if pVhdHandle == NULL, it try only open the VHD file to check if this is VHD file
if the return value is VHD_OPENABLEVHDFILE, we known this is a valid VHD
if pVhdHandle != NULL, it really open the VHD file and store handle on *pVhdHandle if success
This handle will be used in all other function

fAcceptFullRawWithoutHeader : TRUE to accept a full RAW file (like the PFR raw file) without VHD header
lpdwError: *lpdwError will receive a Win32 error code (like GetLastError() API)
fReadOnly : TRUE to open as Read only
*/

VHD_FILE_KIND OpenVhdFile(const VHDLLFILENAMECHAR* lpFileName,
                          VHDMEMORY_BOOL fAcceptFullRawWithoutHeader,
                          VHDFILE_HANDLE * pVhdHandle,
                          VHDMEMORY_UINT4* lpdwError, VHDMEMORY_BOOL fReadOnly);

VHD_FILE_KIND OpenVhdFileA(const char* lpFileName,
                          VHDMEMORY_BOOL fAcceptFullRawWithoutHeader,
                          VHDFILE_HANDLE * pVhdHandle,
                          VHDMEMORY_UINT4* lpdwError, VHDMEMORY_BOOL fReadOnly);

VHD_FILE_KIND OpenVhdFileW(const unsigned short* lpFileName,
                          VHDMEMORY_BOOL fAcceptFullRawWithoutHeader,
                          VHDFILE_HANDLE * pVhdHandle,
                          VHDMEMORY_UINT4* lpdwError, VHDMEMORY_BOOL fReadOnly);

/*
normaly read/write function. Return the number of byte of the operation
lpdwError: *lpdwError will receive a Win32 error code (like GetLastError() API)
*/

VHDMEMORY_UINT4 ReadVhd(VHDFILE_HANDLE vhdHandle,void* buf,VHDMEMORY_UINT8 pos, VHDMEMORY_UINT4 size, VHDMEMORY_UINT4* lpdwError);
VHDMEMORY_UINT4 WriteVhd(VHDFILE_HANDLE vhdHandle,const void* buf,VHDMEMORY_UINT8 pos, VHDMEMORY_UINT4 size, VHDMEMORY_UINT4* lpdwError);

/*
Return the size of the image (not the size of the VHD file, but the size of virtual disk)
*/
VHDMEMORY_UINT8 GetVhdSize(VHDFILE_HANDLE vhdHandle,VHDMEMORY_UINT4* lpdwError);

/*
Close the handle
*/
VHDMEMORY_BOOL CloseVhd(VHDFILE_HANDLE vhdHandle,VHDMEMORY_UINT4* lpdwError);

/*
if the VHD file uses RAW storage (with or without header), return TRUE
*pShift will receive the size of the header BEFORE the raw data (usually 0 with fixed VHD file)
*/
VHDMEMORY_BOOL GetRawFixedDataShift(VHDFILE_HANDLE vhdHandle,VHDMEMORY_UINT8*pShift,VHDMEMORY_UINT4* lpdwError);

#ifdef __cplusplus
}
#endif
