#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <string.h>

#include <windows.h>

#include "wimadll.h"

#include "VhdType.h"
#include "VhdLowFn.h"
#include "VhdSupTl.h"

HIMA TryLoadFloppyIma(LPCSTR lpszImageFileName)
{
    BOOL fCompr=FALSE;
    HIMA hIma = CreateMemFatHima();
    if (hIma!=NULL)
    {
        if (!ReadImaFile(hIma,/*NULL*/HWND_NO_PROGRESS,(LPSTR)lpszImageFileName,&fCompr,0))
        {
            DeleteIma(hIma);
            hIma=NULL;
        }
    }
    return hIma;
}


HIMA TryLoadIsoIma(LPCSTR lpszImageFileName)
{
    return CreateCDIsoIma((LPSTR)lpszImageFileName);
}

    
BOOL DoDirImage(LPCSTR lpszImageFileName,DWORD dwNumPart)
{
    HIMA hIma;
    DWORD dwNbFileRoot,i;
    LPDIRINFO lpdi;
	DWORD dwLowOpen,dwHighOpen;
	dwLowOpen=dwHighOpen=0;
/*
    hIma = TryLoadIsoIma(lpszImageFileName);
    if (hIma!=NULL)
        printf("ISO CdRom image %s opened\n",lpszImageFileName);
    else
    {
        DWORD dwSizeIma,dwSizeImaHigh;
        BOOL fOpenLargeFat=FALSE;
        DWORD dwPosInFile=0;
        if (GetFatImaSizeFileName(lpszImageFileName,&dwSizeIma,&dwSizeImaHigh,&fOpenLargeFat,&dwPosInFile))
        {
            hIma = OpenFatLargeFile(NULL,lpszImageFileName,0,0,TRUE);
            if (hIma!=NULL)
                printf("Hard disk image %s opened\n",lpszImageFileName);
        }

        if ((hIma==NULL) && (!fOpenLargeFat))
        {
            hIma = TryLoadFloppyIma(lpszImageFileName);
            if (hIma!=NULL)
                printf("Fat Floppy image %s opened\n",lpszImageFileName);
        }
    }
*/
	{
		DWORD dwNbPart = 0;
		DWORD dwNbPartFound=0;
		DWORD dwNbFatFound=0;
		DWORD i;
		PARTDESC part[0x20];
		dwNbPart=MakePartitionList(lpszImageFileName,NULL,&dwNbPartFound,&dwNbFatFound,0x20,part);
		printf("number of partition : %u, %u, %u\n",dwNbPart,dwNbPartFound,dwNbFatFound);
		for (i=0;i<dwNbPart;i++)
		{
			printf("Partition number #%u , pos=%08x, pospartition=%08x, type = %u, dist=%08x, size=%08x, is fat : %s\n",
				i,part[i].dwPos,part[i].dwPosPartition,
				part[i].part.bType,part[i].part.dwDist,part[i].part.dwSize,
				((part[i].fIsFat) || (part[i].fIsFat32)) ? "yes":"no");
			DWORD dwLow=part[i].dwPosPartition*512;
			DWORD dwHigh=part[i].dwPosPartition/ (0x1000000/2);
			printf("  low = %08x,high=%08x\n",dwLow,dwHigh);
			if ((dwNumPart==i) && ((part[i].fIsFat) || (part[i].fIsFat32) || (part[i].fIsNtfs) || (part[i].fIsLinux)))
			{
				printf("     -->open this\n");
				dwLowOpen = dwLow;
				dwHighOpen = dwHigh;
			}
		}
		printf("\n\n");
	}

	hIma = OpenLargeImageFile(NULL,lpszImageFileName,dwLowOpen,dwHighOpen,FALSE);
    //hIma = OpenFatLargeFile (NULL,lpszImageFileName,dwLowOpen,dwHighOpen,FALSE);
    if (hIma!=NULL)
    {
        dwNbFileRoot=GetNbEntryCurDir(hIma);
        printf("number of root file : %u\n",dwNbFileRoot);

        lpdi = (LPDIRINFO)malloc(sizeof(DIRINFO)*(dwNbFileRoot+1));
        if (lpdi!=NULL)
        {
            if (GetDirInfo(hIma,lpdi,SORT_NAME))
                for (i=0;i<dwNbFileRoot;i++)
                {
                    printf("%s\t%u\n",(lpdi+i)->longname,(lpdi+i)->dwSize);
                }
            free(lpdi);
        }
        DeleteIma(hIma);
    }

    return hIma!=NULL;
}


HIMA DoOpenImageFile(LPCSTR lpszFileIma)
{
    HIMA hIma;
    hIma = TryLoadFloppyIma(lpszFileIma);
    if (hIma==NULL)
        hIma = TryLoadIsoIma(lpszFileIma);
    return hIma;
}

BOOL WINAPI ExtrVirtCB (LPCVOID lpData,
                                       DWORD dwDataSize,
                                       LPVOID lpUsrParam)
{
    printf("\nCB : len=%u\n",dwDataSize);
    DWORD i;
    for (i=0;i<dwDataSize;i++)
        printf("%c",*(((char*)lpData)+i));
    return TRUE;
}

int tstextr(LPCSTR lpszFileIma)
{
    HIMA hIma;
    BOOL fRetExt;
    hIma = DoOpenImageFile(lpszFileIma);
    if (hIma==NULL)
        return 1;
    if (GetNbEntryCurDir(hIma)==0)
        return 0;
    printf("there is a least one file\n");
/*
    fRetExt=ExtractFile(hIma,0,"d:\\Howler",NULL);
    printf("\n\nExtr res=%s\n",fRetExt ? "TRUE":"FALSE");
    if (GetNbEntryCurDir(hIma)>1)
    {
        fRetExt=ExtractFile(hIma,GetNbEntryCurDir(hIma)-1,"d:\\Howler",NULL);
        printf("\n\nExtr res=%s\n",fRetExt ? "TRUE":"FALSE");
    }
*/
    
    fRetExt=ExtractFileVirtual(hIma,ExtrVirtCB,16384/2,NULL,GetNbEntryCurDir(hIma)-1,"d:\\Howler",NULL);
    printf("\n\nExtr res=%s\n",fRetExt ? "TRUE":"FALSE");
    return 0;
}

int main2(int argc,char *argv[])
{
/*
    {
        DWORD dwRet;
        DWORD dwNbPartFound=0;
        DWORD dwNbFat32Found=0;
        PARTDESC pList[20];
        dwRet=MakePartitionList(
            //"F:\\Documents and Settings\\All Users\\Documents\\Shared Virtual Machines\\Dos Test\\Dos Test.vhd",
            "r:\\gil\\mskey_32_miniboot_dos7raw.pfr",
            NULL,
                           &dwNbPartFound,&dwNbFat32Found,
                           0x20,&pList[0]);
        printf("makelist = %u,%u,%u\n",dwRet,dwNbPartFound,dwNbFat32Found);
    }
  */ 
  printf("DirImage - a WinImage DLL sample - http://www.winimage.com/wima_sdk.htm\n");
  if (argc <= 1)
  {
      printf("Usage : DirImage <image_filename>\n\n");
      return 0;
  }
  else if ((lstrcmpi(argv[1],"tstext")==0) && (argc>2))
  {
      return tstextr(argv[2]);
  }
  else
  {
	  DWORD dwNumPart=0;
	  if (argc>2)
		  dwNumPart=atoi(argv[2]);
      return DoDirImage(argv[1],dwNumPart);
  }
}


int main3(int argc,char *argv[])
{
  /*  
bLowPosition = BinaryAlloc(4)                 ; Position in file Low
bHiPosition  = BinaryAlloc(4)                 ; Position in file High
sWinImgDll   = "Y:\image\Win32\Wimadll_vs2008Ntfs\debug\wimadll.dll"
sVHD_File    = "l:\avirimg\VBUImage.ima"
bfGeom       = BinaryAlloc(8)
bWinHandle   = DllHwnd("~File Copy With Progress Bar")
cDrive = Char2Num("K")

bInputHandle = DllCall(sWinImgDll, long:"OpenFatLargeFile", long:bWinHandle, lpstr:sVHD_File, long:0, long:0, long:1)


bfGeom       = BinaryAlloc(4)

iRet_Code    = DllCall(sWinImgDll, long:"WimLargeWriteLargeImaCBEx", long:bInputHandle, long:bWinHandle, lpnull, lpnull, long:cDrive, lpbinary:bLowPosition, lpbinary:bHiPosition, long:1, long:1, long:1, lpbinary:bfGeom)
*/
    HIMA hIma;
    hIma=OpenFatLargeFile(GetDesktopWindow(),"l:\\avirimg\\VBUImage1.ima",0,0,1);
    BOOL fGeom=FALSE;
    BOOL ret=WimLargeWriteLargeImaCBEx(hIma,GetDesktopWindow(),NULL,NULL,'K',NULL,NULL,USED,TRUE,TRUE,&fGeom);

    return 0;
}

int main4(int argc,char *argv[])
{
  /*  
bLowPosition = BinaryAlloc(4)                 ; Position in file Low
bHiPosition  = BinaryAlloc(4)                 ; Position in file High
sWinImgDll   = "Y:\image\Win32\Wimadll_vs2008Ntfs\debug\wimadll.dll"
sVHD_File    = "l:\avirimg\VBUImage.ima"
bfGeom       = BinaryAlloc(8)
bWinHandle   = DllHwnd("~File Copy With Progress Bar")
cDrive = Char2Num("K")

bInputHandle = DllCall(sWinImgDll, long:"OpenFatLargeFile", long:bWinHandle, lpstr:sVHD_File, long:0, long:0, long:1)


bfGeom       = BinaryAlloc(4)

iRet_Code    = DllCall(sWinImgDll, long:"WimLargeWriteLargeImaCBEx", long:bInputHandle, long:bWinHandle, lpnull, lpnull, long:cDrive, lpbinary:bLowPosition, lpbinary:bHiPosition, long:1, long:1, long:1, lpbinary:bfGeom)
*/
 
    DWORD dwTotal,dwTotalHigh;
    BOOL fRet1=WimLargeReadLargeImaEx(GetDesktopWindow(),'O',"l:\\avirimg\\imgfat32_2048.ima",&dwTotal,&dwTotalHigh,USED);
    BOOL fRet2=WimLargeReadLargeImaEx(GetDesktopWindow(),'P',"l:\\avirimg\\imgfat32_4096.ima",&dwTotal,&dwTotalHigh,USED);
    BOOL fRet3=WimLargeReadLargeImaEx(GetDesktopWindow(),'U',"l:\\avirimg\\imgfat32_8192.ima",&dwTotal,&dwTotalHigh,USED);
    return 0;
}



int mainWinBatch(int argc,char *argv[])
{


    HIMA hIma;
    DWORD dwBegin;

    
    hIma=OpenFatLargeFile(NULL,"g:\\gil\\BOOT98BIS.img",0,0,1);
    BOOL fGeom3=FALSE;
    dwBegin=GetTickCount();
    BOOL ret3=WimLargeWriteLargeImaCBEx(hIma,GetDesktopWindow(),NULL,NULL,'S',NULL,NULL,USED,FALSE,TRUE,&fGeom3);
    DeleteIma(hIma);
    DWORD dwTime3=GetTickCount()-dwBegin;
    {
        char sz[500];
        wsprintf(sz,"ret3=%u, Time = %u msec (%u sec)\n",ret3,dwTime3,dwTime3/1000);
        OutputDebugString(sz);
    }



    return 0;
}



int main(int argc,char *argv[])
{


    const char* lpfnVhd = "l:\\avirimg\\vhdtest.vhd";
    const char* lpfnMaster = "l:\\avirimg\\boot98ter.IMZ";
    ///const char* lpfnMaster = "l:\\avirimg\\bootnt.IMA";

    //const char* lpfnMaster = "l:\\avirimg\\img_boot_7.IMA";
    //const char* lpfnMaster = "l:\\avirimg\\boot_98_ok_resized.IMA";

    //const char* lpfnMaster = "l:\\avirimg\\imgfat32_4096.ima";
    //const char* lpfnMaster = "l:\\avirimg\\caldera_fat32_part.IMA";
//    const char* lpfnMaster = "l:\\avirimg\\caldera_144.IMZ";


    PARTITION_CREATION_INFO pri[] = {
                             { 0x0b,3911744*2,0x80,0 } 
    };
    DWORD i=0;
    for (;;)
    {
        DWORD dwSizeLow,dwSizeHigh;
        dwSizeLow=dwSizeHigh=0;
        BOOL fRemovable=FALSE;
        char szName[0x100]="";

         if (!GetPhysicalDiskSizeAndInfo(i,&dwSizeLow,&dwSizeHigh,
                                 &fRemovable,
                                 szName,sizeof(szName)-1))
                                 break;
         DWORD dwSizeKB = (dwSizeLow >> 10) | (dwSizeHigh << 22);
         DWORD dwNbSector= (dwSizeLow >> 9) | (dwSizeHigh << 23);
         printf("rmv=%c, name=%s, %u KB (%u MB), %u sector\n",fRemovable ? 'y':'n',szName,dwSizeKB,dwSizeKB/1024,dwNbSector);

         if ((fRemovable) /* || ((strcmp(szName,"Msft Virtual Disk 1.0")==0)  && (i==3)*/)
         {
             printf("  will create partition size %u\n",dwNbSector-0x100);
             PARTITION_CREATION_INFO pri;
             pri.dwPositLba = 0x80;
             pri.dwPartitionSize = (dwNbSector-0x81);
             pri.dwPartitionSize -= pri.dwPartitionSize % 0x80;
/*
             if (pri.dwPartitionSize/2 == 2032512)
                 pri.dwPartitionSize = (2032096*2)+1;
*/
             pri.dwClusterSize = 2048;
             pri.dwRootEntryFat1216 = 0;
             pri.dwCreationFat = (dwSizeKB < 1024*1024) ? 16:32;
             pri.dwPartitionType = (pri.dwCreationFat == 32) ? 0x0c : 6;

             pri.dwPositLba = 0x3f;
             //RebuildPartitionAndFormat(i,1,0,&pri);

             DWORD dwPartBoot = 0;


            HIMA hMaster;
            hMaster = CreateMemFatHima();
            ReadImaFile(hMaster,NULL,lpfnMaster,NULL,0);
/*
pri.dwCreationFat=0;
pri.dwPartitionType = 0x0c;
*/
            RebuildPartitionAndFormatAndAdapt(i,1,dwPartBoot,&pri,
                 dwPartBoot,hMaster,GetDesktopWindow(),NULL,NULL,NULL,NULL,USED);
                 //dwPartBoot,hMaster,GetDesktopWindow(),NULL,NULL,NULL,NULL,ALL);

            DeleteIma(hMaster);
         }
         i++;
    }

    HIMA hMaster;
    hMaster = CreateMemFatHima();
    ReadImaFile(hMaster,NULL,lpfnMaster,NULL,0);

    LARGE_INTEGER sizevhd;
    
    sizevhd.QuadPart = 6 ;
    sizevhd.QuadPart *= 1024 * 1024 * 1024;
    sizevhd.QuadPart +=  1024*1024;
    DWORD dwErrVhd=0;
    if (CreateEmptyVhdDynamic(lpfnVhd,sizevhd.QuadPart,&dwErrVhd))
    {
        PARTITION_CREATION_INFO pri[4];
        memset(&pri,0,sizeof(PARTITION_CREATION_INFO)*4);
        // 1gb first partition
        pri[0].dwPositLba = 0x80;
        pri[0].dwPartitionSize = 1 * 1024 * 1024 * 2;
        pri[0].dwPartitionSize /=4;
        //pri[0].dwClusterSize = 65536;
        pri[0].dwCreationFat = 16*2; // fat16


        // 4 gb second partition
        pri[1].dwPositLba = pri[0].dwPositLba + pri[0].dwPartitionSize+0x80;
        pri[1].dwPartitionSize = 4 * 1024 * 1024 * 2;
        pri[1].dwClusterSize = 2048;
        pri[1].dwCreationFat = 32; // fat32
        

        // 2 gb third partition
        pri[2].dwPositLba = pri[1].dwPositLba + pri[1].dwPartitionSize+0x80;
        pri[2].dwPartitionSize = 2 * 1024 * 1024 * 2;
        pri[2].dwClusterSize = 2048;
        pri[2].dwCreationFat = 32; // fat32
/*
        RebuildPartitionAndFormatImage(lpfnVhd,3,1,
                          &pri[0]);
                       */
        DWORD dwPartBoot=0;
        pri[0].dwPositLba = 0x80;
        pri[0].dwPositLba = 0x3f;
        RebuildPartitionAndFormatImageAndAdapt(lpfnVhd,3,dwPartBoot,
                          &pri[0],

                          dwPartBoot,hMaster,GetDesktopWindow(),NULL,NULL,NULL,NULL,USED);
                       
    }
    DeleteIma(hMaster);
    return 0;
}
